#include "TreeNode.hpp"
#include <sstream>
#include <cmath>

TreeNode::TreeNode(int n) : value(n), left(NULL), right(NULL){}

TreeNode::~TreeNode(){
	delete left;
	delete right;
	std::cout << "TreeNode Destruktor" << std::endl;
}

void TreeNode::insert(TreeNode* node){
	//wenn Wert kleiner oder gleich wie an diesem Knoten gehe links weiter
	if(node->value < value){
		if(left==NULL){
			left = node;
			std::cout << node->value << " eingefügt" << std::endl;
		} else {
			left->insert(node);
		}
	//wenn Wert größer, gehe rechts weiter
	} else if(node->value > value) {
		if(right==NULL){
			right = node;
			std::cout << node->value << " eingefügt" << std::endl;
		} else {
			right->insert(node);
		}	
	} else if(node->value == value ){
		std::cout << value << " schon im Baum vorhanden" << std::endl;
		delete node;
	}
}

int TreeNode::count() const{
	if(left==NULL && right==NULL){
		return 1;
	} else if(left==NULL){
		return 1 + right->count();
	} else if(right==NULL){
		return 1 + left->count();
	}	
	return left->count() + 1 + right->count();
}

int TreeNode::height () const{
	if(this == NULL)	return 0;
	return 1 + std::max(left->height(), right->height());
}

int TreeNode::sum() const{
	if(left==NULL && right==NULL)
		return value;
	if(left==NULL)
		return value + right->sum();
	if(right==NULL)
		return value + left->sum();
	return left->sum() + value + right->sum();
}

int TreeNode::min() const{
	if(left==NULL)
		return value;
	return left->min();
}

std::string TreeNode::toString() const {
	std::stringstream strstr;
	if(left==NULL && right==NULL){
		strstr << value;
	} else if(left==NULL){
		strstr << value << " | " << right->toString();
	} else if(right==NULL){
		strstr << left->toString() << " | " << value;
	} else {
		strstr << left->toString() << " | " << value << " | " << right->toString();
	}
	return strstr.str();
}

int main(){
	TreeNode* tree = new TreeNode(15);
	tree->insert(new TreeNode(5));
	tree->insert(new TreeNode(9));
	tree->insert(new TreeNode(17));
	tree->insert(new TreeNode(9));
	tree->insert(new TreeNode(10));
	tree->insert(new TreeNode(2));
	tree->insert(new TreeNode(6));
	tree->insert(new TreeNode(23));
	tree->insert(new TreeNode(19));
	tree->insert(new TreeNode(1));
	tree->insert(new TreeNode(12));
	tree->insert(new TreeNode(31));
	tree->insert(new TreeNode(45));
	tree->insert(new TreeNode(38));
	std::cout << "Summe aller Knoten: " << tree->sum() << std::endl;
	std::cout << "Anzahl Knoten: " << tree->count() << std::endl;
	std::cout << "Höhe: " << tree->height() << std::endl;
	std::cout << "kleinster Wert: " << tree->min() << std::endl;
	std::cout << "Kompletter Baum: " << tree->toString() << std::endl;
	delete tree;
}

