#ifndef _COMPLEXFRACTAL_HPP_
#define _COMPLEXFRACTAL_HPP_

#include <complex>

/**
 * Interface für Fraktale in der komplexen Zahlenebene
 *
 * @author Sebastian Flothow <sebastian@flothow.de>
 */
class ComplexFractal {
public:
	/**
	 * Berechnet den Wert für einen bestimmten Punkt
	 * 
	 * @param s Punkt in der komplexen Zahlenebene, für den die Berechnung durchgeführt werden soll
	 * @return Ergebnis der Berechnung, liegt im Intervall [0; 1]
	 */
	virtual double calculate(const std::complex<double>& s) const = 0;
	
	/**
	 * Virtueller Destruktor, damit delete für einen ComplexFractal-Pointer korrekt funktioniert
	 */
	virtual ~ComplexFractal() {}
};

#endif
