#ifndef _COMPLEXFRACTALRENDERER_HPP_
#define _COMPLEXFRACTALRENDERER_HPP_

#include <QImage>
#include <memory>

#include "complexfractal.hpp"
#include "colormapper.hpp"

/**
 * Berechnet ein Fraktal in der Ebene der komplexen Zahlen
 *
 * @author Sebastian Flothow <sebastian@flothow.de>
 */ 
class ComplexFractalRenderer {
public:
	/**
	 * Erzeugt einen ComplexFractalRenderer.
	 *
	 * @param fractal Fraktal, das gerendert werden soll. Der neue ComplexFractalRenderer wird Eigentümer des ComplexFractal-Objekts.
	 * @param mapper Färbung, die verwendet werden soll. Der neue ComplexFractalRenderer wird Eigentümer des ColorMapper-Objekts.
	 */
	ComplexFractalRenderer(ComplexFractal* fractal, ColorMapper* mapper);
	
	/**
	 * Rendert das Fraktal.
	 *
	 * @param topleft Komplexer Zahlenwert des oberen linken Pixels
	 * @param step Schrittweite entlang der realen bzw. imaginären Axe pro Pixel
	 * @param width Breite des zu rendernden Bilds in Pixeln
	 * @param height Höhe des zu rendernden Bilds in Pixeln
	 * @return Das gerenderte Fraktal
	 */
	QImage render(std::complex<double> topleft = std::complex<double>(-3, 1.5), double step = 0.005, int width = 800, int height = 600) const;
	
private:
	// Verwendung von autopointern erspart uns die Implementation von Destruktor, Kopierkonstruktor und Zuweisungsoperator
	// (allerdings überträgt sich dadurch die merkwürdige Kopiersemantik der autopointer auf diese Klasse)
	std::auto_ptr<ComplexFractal> fractal;
	std::auto_ptr<ColorMapper> mapper;
};

#endif
