#ifndef _COLORMAPPER_HPP_
#define _COLORMAPPER_HPP_

#include <QColor>

/**
 * Interface für Farb-Abbildungen
 *
 * @author Sebastian Flothow <sebastian@flothow.de>
 */
class ColorMapper {
public:
	/**
	 * Gibt zu einem Fraktal-Wert die zugehörige Farbe zurück.
	 * 
	 * @param v Durch ein Fraktal berechneter Wert im Intervall [0; 1]
	 * @return Zugehörige Farbe
	 */
	virtual QRgb map(double v) const = 0;
	
	/**
	 * Virtueller Destruktor, damit delete für einen ColorMapper-Pointer korrekt funktioniert
	 */
	virtual ~ColorMapper() {}
};

#endif
