#include "complexfractalrenderer.hpp"

using std::complex;

ComplexFractalRenderer::ComplexFractalRenderer(ComplexFractal* fractal, ColorMapper* mapper) : fractal(fractal), mapper(mapper) {}

QImage ComplexFractalRenderer::render(complex<double> s, double step, int width, int height) const {
	QImage img(width, height, QImage::Format_RGB32);
	
	for (int x = 0; x < width; x++) {
		complex<double> t(s);
		
		for (int y = 0; y < height; y++) {
			double val = fractal->calculate(t);
			QRgb color = mapper->map(val);
			img.setPixel(x, y, color);
			
			t -= complex<double>(0, step);
		}
		
		s += step;
	}
	
	return img;
}
